/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.updater;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import javax.swing.SwingWorker;
import net.feed_the_beast.launcher.json.JsonFactory;
import net.feed_the_beast.launcher.json.launcher.Channel;
import net.feed_the_beast.launcher.json.launcher.Update;
import net.ftb.data.Settings;
import net.ftb.download.Locations;
import net.ftb.gui.LaunchFrame;
import net.ftb.log.Logger;
import net.ftb.updater.SelfUpdate;
import net.ftb.util.AppUtils;
import net.ftb.util.DownloadUtils;
import net.ftb.util.FileUtils;
import net.ftb.util.OSUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;

public class UpdateChecker
extends SwingWorker<Boolean, Void> {
    private int version;
    private int buildJenk;
    private int beta;
    private int betaJenk;
    private int relJenk;
    private int latest;
    private int minUsable;
    public static String verString = "";
    public static String betaStr = "";
    private String downloadAddress = "";
    private String betaAddress = "";
    private boolean allowBeta;
    private boolean useBeta;
    private List<String> betaHash;
    public static String UCString;

    public UpdateChecker(int version, int minUsable, int buildJenk) {
        this.version = version;
        this.minUsable = minUsable;
        this.allowBeta = Settings.getSettings().isBetaChannel();
        this.buildJenk = buildJenk;
        if (buildJenk == 9999999) {
            this.allowBeta = false;
        }
        String path = null;
        try {
            path = new File(LaunchFrame.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getCanonicalPath();
            path = URLDecoder.decode(path, "UTF-8");
            Logger.logDebug("Launcher Install path: " + path);
        }
        catch (IOException e) {
            Logger.logError("Couldn't get path to current launcher jar/exe", e);
        }
    }

    @Override
    protected Boolean doInBackground() {
        this.loadInfo();
        try {
            FileUtils.delete(new File(OSUtils.getCacheStorageLocation(), "updatetemp"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.shouldUpdate();
    }

    private void loadInfo() {
        try {
            Document doc = AppUtils.downloadXML(new URL(DownloadUtils.getStaticCreeperhostLink("version.xml")));
            Update upd = JsonFactory.getUpdate("net.ftb:launcher:beta@json", Locations.FTBMAVENFULL);
            if (upd.getPrimary().equals("beta")) {
                Channel beta = upd.getBeta();
                this.betaJenk = beta.getJenkins();
                int beta_ = this.beta = beta.getVersion();
                betaStr = betaStr + beta_ / 10000 + ".";
                betaStr = betaStr + (beta_ %= 10000) / 100 + ".";
                betaStr = betaStr + (beta_ %= 100);
                this.betaAddress = beta.getFile().getUrl() + beta.getFile().getPath();
                if (beta.getFile().checksums != null) {
                    this.betaHash = beta.getFile().checksums;
                }
                if (upd.getRelease() != null) {
                    // empty if block
                }
            }
            if (doc == null) {
                return;
            }
            NamedNodeMap updateAttributes = doc.getDocumentElement().getAttributes();
            int latest_ = this.latest = Integer.parseInt(updateAttributes.getNamedItem("currentBuild").getTextContent());
            verString = verString + latest_ / 10000 + ".";
            verString = verString + (latest_ %= 10000) / 100 + ".";
            verString = verString + (latest_ %= 100);
            this.downloadAddress = updateAttributes.getNamedItem("downloadURL").getTextContent();
            if (updateAttributes.getNamedItem("releaseJenkins") != null) {
                this.relJenk = Integer.parseInt(updateAttributes.getNamedItem("releaseJenkins").getTextContent());
            } else {
                Logger.logInfo("Beta channel hasn't been activated yet!");
            }
        }
        catch (Exception e) {
            Logger.logError("Error while loading launcher update info", e);
        }
    }

    public boolean shouldUpdate() {
        Logger.logDebug("updater: buildjenk " + this.buildJenk + " < betajenk " + this.betaJenk + "|| version " + this.version + " < " + this.beta);
        Logger.logDebug("latest = " + this.latest);
        if (this.allowBeta && (this.buildJenk < this.betaJenk || this.version < this.beta)) {
            Logger.logInfo("New beta version found. version: " + this.version + "-" + this.buildJenk + ", latest: " + this.beta + "-" + this.betaJenk);
            UCString = "BETA version " + betaStr + "-" + this.betaJenk;
            this.useBeta = true;
            return true;
        }
        if (this.version == this.latest && this.buildJenk < this.relJenk) {
            Logger.logInfo("Release version found. version: " + this.version + "-" + this.buildJenk + ", latest: " + this.latest);
            this.useBeta = false;
            UCString = "Version " + verString;
            return true;
        }
        if (this.version < this.latest) {
            Logger.logInfo("New version found. version: " + this.version + ", latest: " + this.latest);
            this.useBeta = false;
            UCString = "Version " + verString;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update() {
        String path = null;
        try {
            path = new File(LaunchFrame.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getCanonicalPath();
            path = URLDecoder.decode(path, "UTF-8");
            Logger.logDebug("Launcher Install path: " + path);
        }
        catch (IOException e) {
            Logger.logError("Couldn't get path to current launcher jar/exe", e);
        }
        String temporaryUpdatePath = OSUtils.getCacheStorageLocation() + File.separator + "updatetemp" + "/" + path.substring(path.lastIndexOf(File.separator) + 1);
        String extension = path.substring(path.lastIndexOf(46) + 1);
        extension = "exe".equalsIgnoreCase(extension) ? extension : "jar";
        try {
            URL updateURL = new URL(!this.useBeta ? DownloadUtils.getCreeperhostLink(this.downloadAddress + "." + extension) : this.betaAddress.replace("${ext}", extension).replace("${jenkins}", Integer.toString(this.betaJenk)).replace("${version}", betaStr));
            File temporaryUpdate = new File(temporaryUpdatePath);
            temporaryUpdate.getParentFile().mkdir();
            DownloadUtils.downloadToFile(updateURL, temporaryUpdate);
            if (this.useBeta && this.betaHash != null) {
                String sha = DownloadUtils.fileSHA(temporaryUpdate);
                if (this.betaHash.contains(sha)) {
                    SelfUpdate.runUpdate(path, temporaryUpdate.getCanonicalPath());
                    return;
                }
                Logger.logDebug("TempPath" + temporaryUpdatePath);
                throw new IOException("Update Download failed hash check please try again! -- fileSha " + sha);
            }
            SelfUpdate.runUpdate(path, temporaryUpdatePath);
            return;
        }
        catch (Exception e) {
            Logger.logError("Error while updating launcher", e);
        }
    }
}

